<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Pages extends CI_Controller {

    public function __construct(){
        parent::__construct();
         $this->load->model('About_model','about');
         $this->load->model('Product_model','product');
        $this->load->model('Portfolio_model','portfolio');
        $this->load->model('Kontak_model','kontak_model'); // <-- TAMBAHKAN INI
    }

    private function render($view, $data = []){
        $this->load->view('layouts/header', $data);
        $this->load->view($view, $data);
        $this->load->view('layouts/footer');
    }

    public function index(){
        $data['title'] = 'Beranda';
        $data['items'] = $this->portfolio->latest(6);
        $this->render('pages/home', $data);
    }

    public function tentang(){
        $data['title']   = 'Tentang';
        $data['about']   = $this->about->get();
        $data['gallery'] = $this->about->gallery_all();
        $this->render('pages/tentang', $data);
    }

    public function portofolio(){
        $data['title'] = 'Portofolio';
        $data['items'] = $this->portfolio->all();
        $this->render('pages/portofolio', $data);
    }

    public function kontak(){
        $data['title'] = 'Kontak';
        $this->render('pages/kontak', $data);
    }
    
    public function produk(){
        $data['title'] = 'Produk';
        $data['items'] = $this->product->all();
        $this->render('pages/produk', $data);
    }

    
    public function kirim_kontak(){
        if (!$this->input->post()) show_404();

        $this->form_validation->set_rules('nama','Nama','required|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('email','Email','required|valid_email');
        // Validasi untuk nomer_hp
        $this->form_validation->set_rules('nomer_hp','Nomer HP','required|min_length[10]|max_length[15]');
        $this->form_validation->set_rules('pesan','Pesan','required|min_length[10]');

        if($this->form_validation->run() === FALSE){ 
            return $this->kontak(); 
        }

        // Ambil data dari form
        $data_to_save = [
            'nama'     => html_escape($this->input->post('nama', TRUE)),
            'email'    => html_escape($this->input->post('email', TRUE)),
            'nomer_hp' => html_escape($this->input->post('nomer_hp', TRUE)),
            'pesan'    => html_escape($this->input->post('pesan', TRUE)),
            'tanggal_kirim' => date('Y-m-d H:i:s')
        ];
        
        // Simpan ke database
        if($this->kontak_model->simpan($data_to_save)){ 
            $this->session->set_flashdata('ok','Pesan berhasil dikirim.'); 
        }
        else { 
            $this->session->set_flashdata('err','Gagal menyimpan pesan.'); 
        }

        // Opsional: Anda masih bisa tetap mengirim email jika mau
        // $this->email->from($data_to_save['email'], $data_to_save['nama']);
        // $this->email->to('you@domain.com');
        // $this->email->subject('Pesan dari Web Profile');
        // $this->email->message("Nama: {$data_to_save['nama']}\nEmail: {$data_to_save['email']}\nHP: {$data_to_save['nomer_hp']}\n\n{$data_to_save['pesan']}");
        // $this->email->send();

        redirect('kontak');
    }
}