<?php defined('BASEPATH') OR exit('No direct script access allowed');

class About extends CI_Controller {

    public function __construct(){
        parent::__construct();
        if (!$this->session->userdata('admin_id')) redirect('admin/login');
        $this->load->model('About_model','about');
        $this->load->helper(['url','file','form','security']);
    }

    private function render($view,$data=[]){
        $this->load->view('admin/layouts/header',$data);
        $this->load->view($view,$data);
        $this->load->view('admin/layouts/footer');
    }

    public function index(){
        $data['title']   = 'Kelola Halaman Tentang';
        $data['row']     = $this->about->get();
        $data['gallery'] = $this->about->gallery_all();

        if ($this->input->method()==='post'){
            // validasi
            $this->form_validation->set_rules('content','Konten','required|min_length[5]');
            $this->form_validation->set_rules('address','Alamat','trim');
            $this->form_validation->set_rules('phone','Nomor Telepon','trim');

            if ($this->form_validation->run()){
                $update = [
                    'content' => $this->input->post('content', TRUE),
                    'address' => $this->input->post('address', TRUE),
                    'phone'   => $this->input->post('phone', TRUE),
                ];

                // upload gambar utama (opsional)
                if (!empty($_FILES['hero']['name'])){
                    $config = [
                        'upload_path'   => './assets/img/about/',
                        'allowed_types' => 'jpg|jpeg|png|webp',
                        'max_size'      => 4096,
                        'encrypt_name'  => TRUE,
                    ];
                    $this->load->library('upload', $config);
                    if ($this->upload->do_upload('hero')){
                        $filename = $this->upload->data('file_name');
                        $this->_resize_main($filename);  // maks 1200px
                        $update['hero_image'] = $filename;

                        // hapus lama bila ada
                        if (!empty($data['row']->hero_image)){
                            $this->_delete_image_files($data['row']->hero_image, 'about');
                        }
                    } else {
                        $this->session->set_flashdata('err',$this->upload->display_errors('',''));
                        return redirect('admin/about');
                    }
                }

                // simpan info utama
                $this->about->upsert($update);

                // upload galeri (bisa banyak, opsional)
                if (!empty($_FILES['gallery']['name'][0])){
                    $count = count($_FILES['gallery']['name']);
                    $config2 = [
                        'upload_path'   => './assets/img/about/',
                        'allowed_types' => 'jpg|jpeg|png|webp',
                        'max_size'      => 4096,
                        'encrypt_name'  => TRUE,
                    ];
                    $this->load->library('upload');
                    for($i=0; $i<$count; $i++){
                        if(empty($_FILES['gallery']['name'][$i])) continue;
                        // mapping file per iterasi
                        $_FILES['single']['name']     = $_FILES['gallery']['name'][$i];
                        $_FILES['single']['type']     = $_FILES['gallery']['type'][$i];
                        $_FILES['single']['tmp_name'] = $_FILES['gallery']['tmp_name'][$i];
                        $_FILES['single']['error']    = $_FILES['gallery']['error'][$i];
                        $_FILES['single']['size']     = $_FILES['gallery']['size'][$i];

                        $this->upload->initialize($config2);
                        if($this->upload->do_upload('single')){
                            $fname = $this->upload->data('file_name');
                            $this->_resize_main($fname, 'about');
                            $this->_make_thumb($fname, 360, 240, 'about'); // buat thumb
                            $this->about->gallery_add($fname, null);
                        }
                        // kalau gagal, skip; biar upload lain tetap lanjut
                    }
                }

                $this->session->set_flashdata('ok','Data "Tentang" berhasil disimpan.');
                return redirect('admin/about');
            }
        }

        $this->render('admin/about_form', $data);
    }

    public function gallery_delete($id){
        $row = $this->about->gallery_get($id);
        if($row){
            $this->_delete_image_files($row->image, 'about');
            $this->about->gallery_delete($id);
            $this->session->set_flashdata('ok','Foto galeri dihapus.');
        }
        redirect('admin/about');
    }

    // ==== Helpers (mirip Portfolio) ====
    private function _resize_main($filename, $dir='about'){
        $source = FCPATH.'assets/img/'.$dir.'/'.$filename;
        $config = [
            'image_library'  => 'gd2',
            'source_image'   => $source,
            'new_image'      => $source,
            'maintain_ratio' => TRUE,
            'width'          => 1200,
            'height'         => 1200,
            'quality'        => '85%'
        ];
        $this->load->library('image_lib', $config);
        $this->image_lib->resize();
        $this->image_lib->clear();
    }

    private function _make_thumb($filename, $tw=360, $th=240, $dir='about'){
        $src   = FCPATH.'assets/img/'.$dir.'/'.$filename;
        $pi    = pathinfo($src);
        $thumb = $pi['dirname'].'/'.$pi['filename'].'_thumb.'.$pi['extension'];
        @copy($src, $thumb);

        // resize sesuai rasio terdekat
        $size = @getimagesize($thumb);
        if ($size){
            $w=$size[0]; $h=$size[1]; $target_ratio=$tw/$th; $img_ratio = $h==0?1:($w/$h);
            $conf = ['image_library'=>'gd2','source_image'=>$thumb,'new_image'=>$thumb,'maintain_ratio'=>TRUE];
            if($img_ratio > $target_ratio) $conf['height'] = $th; else $conf['width'] = $tw;
            $this->image_lib->initialize($conf); $this->image_lib->resize(); $this->image_lib->clear();
        }
        // crop tengah
        $size = @getimagesize($thumb);
        if($size){
            $w=$size[0]; $h=$size[1]; $x=max(0,intval(($w-$tw)/2)); $y=max(0,intval(($h-$th)/2));
            $conf = ['image_library'=>'gd2','source_image'=>$thumb,'new_image'=>$thumb,'maintain_ratio'=>FALSE,'width'=>$tw,'height'=>$th,'x_axis'=>$x,'y_axis'=>$y];
            $this->image_lib->initialize($conf); $this->image_lib->crop(); $this->image_lib->clear();
        }
    }

    private function _delete_image_files($filename, $dir='about'){
        $main  = FCPATH.'assets/img/'.$dir.'/'.$filename;
        $pi    = pathinfo($main);
        $thumb = $pi['dirname'].'/'.$pi['filename'].'_thumb.'.$pi['extension'];
        @unlink($main);
        @unlink($thumb);
    }
}
