<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kontak extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        
        // PENTING: Disesuaikan agar konsisten dengan Product.php
        if (!$this->session->userdata('admin_id')) { 
            $this->session->set_flashdata('err', 'Silakan login terlebih dahulu.');
            redirect('admin/login');
        }

        // Load model
        $this->load->model('Kontak_model', 'kontak_model');
    }

    // Fungsi helper untuk me-load layout admin
    // Disesuaikan agar konsisten dengan Product.php
    private function render_admin($view, $data = [])
    {
        // Path disesuaikan ke 'admin/layouts/...'
        $this->load->view('admin/layouts/header', $data); 
        $this->load->view($view, $data);             // Konten spesifik
        // FIX: $this.load -> $this->load
        $this->load->view('admin/layouts/footer');   
    }

    // Method ini akan dipanggil oleh .../admin/kontak
    public function index()
    {
        $data['title'] = 'Pesan Masuk';
        $data['messages'] = $this->kontak_model->get_all();
        
        // Memuat view yang sudah Anda buat
        $this->render_admin('admin/kontak_index', $data); 
    }

    // Method ini akan dipanggil oleh .../admin/kontak/hapus/[id]
    public function hapus($id = null)
    {
        if (!$id) {
            show_404();
        }

        if ($this->kontak_model->hapus($id)) {
            $this->session->set_flashdata('ok', 'Pesan berhasil dihapus.');
        } else {
            // FIX: $this.session -> $this->session
            $this->session->set_flashdata('err', 'Gagal menghapus pesan.');
        }
        redirect('admin/kontak');
    }
}