<style>
  /* Page Header */
  .page-header {
    background: linear-gradient(135deg, rgba(0, 119, 190, 0.1), rgba(0, 191, 165, 0.1));
    border-left: 5px solid;
    border-image: linear-gradient(180deg, var(--ocean-blue), var(--aqua-green)) 1;
    padding: 1.5rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 5px 20px rgba(0, 119, 190, 0.1);
    animation: slideInDown 0.5s ease;
  }

  @keyframes slideInDown {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

  .page-header h3 {
    margin: 0;
    font-weight: 700;
    background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    display: flex;
    align-items: center;
    gap: 0.75rem;
  }

  .page-header h3::before {
    content: '📝';
    font-size: 1.8rem;
  }

  /* Form Styling */
  .form-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 191, 165, 0.2);
    border-radius: 15px;
    padding: 2rem;
    box-shadow: 0 10px 30px rgba(0, 119, 190, 0.1);
    margin-bottom: 2rem;
    animation: fadeInUp 0.6s ease;
  }

  @keyframes fadeInUp {
    from {
      opacity: 0;
      transform: translateY(30px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

  .form-label {
    font-weight: 600;
    color: var(--deep-blue);
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }

  .form-label::before {
    content: '🔹';
    font-size: 0.9rem;
  }

  .form-control, .form-select {
    border: 2px solid rgba(0, 191, 165, 0.2);
    border-radius: 10px;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
    background: rgba(255, 255, 255, 0.9);
  }

  .form-control:focus, .form-select:focus {
    border-color: var(--aqua-green);
    box-shadow: 0 0 0 0.25rem rgba(0, 191, 165, 0.15);
    background: white;
  }

  .form-control:hover, .form-select:hover {
    border-color: var(--aqua-green);
  }

  textarea.form-control {
    resize: vertical;
    min-height: 120px;
  }

  .form-text {
    color: #6c757d;
    font-size: 0.875rem;
    margin-top: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }

  .form-text::before {
    content: 'ℹ️';
  }

  /* Image Preview */
  .image-preview {
    margin-top: 1rem;
    padding: 1rem;
    background: linear-gradient(135deg, rgba(0, 119, 190, 0.05), rgba(0, 191, 165, 0.05));
    border-radius: 12px;
    border: 2px dashed rgba(0, 191, 165, 0.3);
  }

  .image-preview img {
    border-radius: 10px;
    border: 3px solid white;
    box-shadow: 0 5px 20px rgba(0, 119, 190, 0.2);
    transition: transform 0.3s ease;
  }

  .image-preview img:hover {
    transform: scale(1.05);
  }

  /* Buttons */
  .btn-primary {
    background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
    border: none;
    border-radius: 10px;
    padding: 0.75rem 2rem;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 5px 15px rgba(0, 119, 190, 0.3);
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
  }

  .btn-primary::before {
    content: '💾';
  }

  .btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 119, 190, 0.4);
  }

  .btn-secondary {
    background: linear-gradient(135deg, #6c757d, #5a6268);
    border: none;
    border-radius: 10px;
    padding: 0.75rem 2rem;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 5px 15px rgba(108, 117, 125, 0.3);
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
  }

  .btn-secondary::before {
    content: '◀️';
  }

  .btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(108, 117, 125, 0.4);
  }

  /* Divider */
  .custom-divider {
    margin: 3rem 0;
    height: 2px;
    background: linear-gradient(90deg, transparent, var(--aqua-green), transparent);
    border: none;
    position: relative;
  }

  .custom-divider::after {
    content: '🐠';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: white;
    padding: 0 1rem;
    font-size: 1.5rem;
  }

  /* Gallery Section */
  .gallery-header {
    background: linear-gradient(135deg, rgba(0, 119, 190, 0.1), rgba(0, 191, 165, 0.1));
    padding: 1rem 1.5rem;
    border-radius: 12px;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    box-shadow: 0 5px 15px rgba(0, 119, 190, 0.1);
  }

  .gallery-header h5 {
    margin: 0;
    font-weight: 700;
    background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
  }

  .gallery-header::before {
    content: '🖼️';
    font-size: 1.5rem;
  }

  /* Gallery Cards */
  .gallery-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border: 2px solid rgba(0, 191, 165, 0.2);
    border-radius: 15px;
    overflow: hidden;
    transition: all 0.3s ease;
    box-shadow: 0 5px 20px rgba(0, 119, 190, 0.1);
    height: 100%;
  }

  .gallery-card:hover {
    transform: translateY(-5px) scale(1.02);
    box-shadow: 0 15px 40px rgba(0, 119, 190, 0.25);
    border-color: var(--aqua-green);
  }

  .gallery-card img {
    transition: transform 0.3s ease;
  }

  .gallery-card:hover img {
    transform: scale(1.1);
  }

  .gallery-card .card-img-top {
    position: relative;
    overflow: hidden;
  }

  .gallery-card .card-body {
    padding: 1rem;
    background: linear-gradient(135deg, rgba(0, 119, 190, 0.05), rgba(0, 191, 165, 0.05));
  }

  .btn-outline-danger {
    border: 2px solid var(--coral);
    color: var(--coral);
    border-radius: 8px;
    font-weight: 600;
    padding: 0.5rem 1rem;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
  }

  .btn-outline-danger::before {
    content: '🗑️';
  }

  .btn-outline-danger:hover {
    background: var(--coral);
    color: white;
    transform: scale(1.05);
    box-shadow: 0 5px 15px rgba(255, 107, 107, 0.3);
  }

  /* Empty State */
  .empty-state {
    text-align: center;
    padding: 3rem 2rem;
    background: linear-gradient(135deg, rgba(0, 119, 190, 0.05), rgba(0, 191, 165, 0.05));
    border: 2px dashed rgba(0, 191, 165, 0.3);
    border-radius: 15px;
    color: #6c757d;
  }

  .empty-state::before {
    content: '📷';
    display: block;
    font-size: 3rem;
    margin-bottom: 1rem;
    opacity: 0.5;
  }

  /* Alert Styling */
  .alert-danger {
    background: linear-gradient(135deg, rgba(255, 107, 107, 0.9), rgba(255, 107, 107, 0.7));
    color: white;
    border: none;
    border-radius: 12px;
    padding: 1rem 1.5rem;
    box-shadow: 0 5px 20px rgba(255, 107, 107, 0.3);
    display: flex;
    align-items: center;
    gap: 0.75rem;
    animation: shake 0.5s ease;
  }

  .alert-danger::before {
    content: '⚠️';
    font-size: 1.5rem;
  }

  @keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-10px); }
    75% { transform: translateX(10px); }
  }

  /* Validation Errors List */
  .alert-danger ul {
    margin: 0;
    padding-left: 1.5rem;
  }

  .alert-danger li {
    margin: 0.25rem 0;
  }

  /* Responsive */
  @media (max-width: 768px) {
    .form-card {
      padding: 1.5rem;
    }

    .page-header {
      padding: 1rem;
    }

    .btn-primary, .btn-secondary {
      padding: 0.6rem 1.5rem;
      font-size: 0.9rem;
    }

    .gallery-card {
      margin-bottom: 1rem;
    }
  }
</style>

<div class="page-header">
  <h3>Kelola Halaman Tentang</h3>
</div>

<?php if(validation_errors()): ?>
  <div class="alert alert-danger">
    <?= validation_errors(); ?>
  </div>
<?php endif; ?>

<div class="form-card">
  <?= form_open_multipart('admin/about'); ?>
    <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>

    <div class="mb-4">
      <label class="form-label">Konten / Deskripsi</label>
      <textarea name="content" rows="6" class="form-control" required placeholder="Ceritakan tentang akuarium Anda..."><?= set_value('content', isset($row)?$row->content:''); ?></textarea>
    </div>

    <div class="row">
      <div class="col-md-6 mb-4">
        <label class="form-label">Alamat</label>
        <input type="text" name="address" value="<?= set_value('address', isset($row)?$row->address:''); ?>" class="form-control" placeholder="Jl. Contoh No. 123">
      </div>
      <div class="col-md-6 mb-4">
        <label class="form-label">Nomor Telepon</label>
        <input type="text" name="phone" value="<?= set_value('phone', isset($row)?$row->phone:''); ?>" class="form-control" placeholder="+62 812-3456-7890">
      </div>
    </div>

    <div class="mb-4">
      <label class="form-label">Gambar Utama</label>
      <input type="file" name="hero" class="form-control" accept="image/*">
      <div class="form-text">Opsional • akan menimpa gambar yang lama</div>
      <?php if(!empty($row->hero_image)): ?>
        <div class="image-preview">
          <img src="<?= base_url('assets/img/about/'.$row->hero_image); ?>" style="height:120px" class="rounded" alt="Hero Image">
        </div>
      <?php endif; ?>
    </div>

    <div class="mb-4">
      <label class="form-label">Foto Tambahan</label>
      <input type="file" name="gallery[]" class="form-control" multiple accept="image/*">
      <div class="form-text">Bisa pilih banyak • JPG/PNG/WEBP • Maks 4MB per file • Akan dibuat thumbnail 360×240</div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
      <a href="<?= site_url('admin'); ?>" class="btn btn-secondary">Kembali</a>
    </div>
  <?= form_close(); ?>
</div>

<hr class="custom-divider">

<div class="gallery-header">
  <h5>Galeri Foto</h5>
</div>

<?php if(empty($gallery)): ?>
  <div class="empty-state">
    <strong>Belum ada foto di galeri</strong>
    <p class="mb-0 mt-2">Upload foto untuk memulai galeri Anda</p>
  </div>
<?php else: ?>
  <div class="row g-3">
    <?php foreach($gallery as $g): ?>
      <div class="col-6 col-md-4 col-lg-3">
        <div class="gallery-card">
          <img class="card-img-top" src="<?= base_url('assets/img/about/'.html_escape($g->image)); ?>" style="height:180px;object-fit:cover" alt="Gallery Image">
          <div class="card-body">
            <a class="btn btn-outline-danger btn-sm w-100" onclick="return confirm('Yakin ingin menghapus foto ini?')"
               href="<?= site_url('admin/about/hapus/'.$g->id); ?>">Hapus</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>