<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <title>Login Admin - Aquarium Paradise</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <style>
    :root {
      --ocean-blue: #0077be;
      --aqua-green: #00bfa5;
      --deep-blue: #004d7a;
      --light-blue: #e0f7fa;
      --coral: #ff6b6b;
    }

    body {
      background: linear-gradient(135deg, #0077be 0%, #00bfa5 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      position: relative;
      overflow: hidden;
    }

    /* Animated Ocean Background */
    body::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        radial-gradient(circle at 20% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(0, 0, 0, 0.1) 0%, transparent 50%);
      animation: pulse 8s ease-in-out infinite;
    }

    @keyframes pulse {
      0%, 100% { opacity: 1; }
      50% { opacity: 0.8; }
    }

    /* Bubbles Container */
    .bubbles-container {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      pointer-events: none;
      z-index: 1;
      overflow: hidden;
    }

    .bubble {
      position: absolute;
      bottom: -100px;
      background: radial-gradient(circle at 30% 30%, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.3));
      border-radius: 50%;
      opacity: 0.5;
      animation: rise linear infinite;
      box-shadow: inset 0 0 10px rgba(255, 255, 255, 0.8),
                  0 0 20px rgba(255, 255, 255, 0.4);
    }

    .bubble::before {
      content: '';
      position: absolute;
      top: 10%;
      left: 15%;
      width: 30%;
      height: 30%;
      background: rgba(255, 255, 255, 0.8);
      border-radius: 50%;
      filter: blur(2px);
    }

    @keyframes rise {
      0% {
        bottom: -100px;
        transform: translateX(0) scale(1);
        opacity: 0;
      }
      10% {
        opacity: 0.5;
      }
      50% {
        transform: translateX(20px) scale(1.1);
      }
      90% {
        opacity: 0.5;
      }
      100% {
        bottom: 110vh;
        transform: translateX(-20px) scale(0.8);
        opacity: 0;
      }
    }

    /* Login Container */
    .login-container {
      position: relative;
      z-index: 10;
      width: 100%;
      max-width: 450px;
      padding: 0 15px;
    }

    /* Login Card */
    .login-card {
      background: rgba(255, 255, 255, 0.98);
      backdrop-filter: blur(20px);
      border-radius: 30px;
      border: 2px solid rgba(255, 255, 255, 0.3);
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3),
                  inset 0 1px 0 rgba(255, 255, 255, 0.5);
      overflow: hidden;
      animation: fadeInUp 0.6s ease-out;
    }

    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .login-header {
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      padding: 2.5rem 2rem 2rem;
      text-align: center;
      position: relative;
      overflow: hidden;
    }

    .login-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1200 120'%3E%3Cpath d='M321.39 56.44c58-10.79 114.16-30.13 172-41.86 82.39-16.72 168.19-17.73 250.45-.39C823.78 31 906.67 72 985.66 92.83c70.05 18.48 146.53 26.09 214.34 3V0H0v27.35a600.21 600.21 0 00321.39 29.09z' fill='rgba(255,255,255,0.1)'/%3E%3C/svg%3E") no-repeat bottom;
      background-size: cover;
      opacity: 0.5;
    }

    .login-icon {
      font-size: 4rem;
      margin-bottom: 1rem;
      animation: float 3s ease-in-out infinite;
      display: inline-block;
    }

    @keyframes float {
      0%, 100% { transform: translateY(0); }
      50% { transform: translateY(-10px); }
    }

    .login-header h4 {
      color: white;
      font-size: 1.8rem;
      font-weight: 700;
      margin: 0;
      text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2);
      position: relative;
      z-index: 1;
    }

    .login-header p {
      color: rgba(255, 255, 255, 0.9);
      margin: 0.5rem 0 0;
      font-size: 0.95rem;
      position: relative;
      z-index: 1;
    }

    .login-body {
      padding: 2.5rem 2rem;
    }

    /* Form Styling */
    .form-label {
      color: var(--deep-blue);
      font-weight: 600;
      font-size: 0.9rem;
      margin-bottom: 0.5rem;
    }

    .form-control {
      border: 2px solid #e0f7fa;
      border-radius: 15px;
      padding: 0.75rem 1.25rem;
      font-size: 1rem;
      transition: all 0.3s ease;
      background: rgba(224, 247, 250, 0.3);
    }

    .form-control:focus {
      border-color: var(--aqua-green);
      box-shadow: 0 0 0 0.25rem rgba(0, 191, 165, 0.15),
                  0 5px 15px rgba(0, 191, 165, 0.1);
      background: white;
      transform: translateY(-2px);
    }

    .form-control::placeholder {
      color: #b0bec5;
    }

    /* Input Icons */
    .input-group {
      position: relative;
    }

    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      font-size: 1.2rem;
      color: var(--ocean-blue);
      z-index: 5;
      pointer-events: none;
    }

    .input-group .form-control {
      padding-left: 3rem;
    }

    /* Button Styling */
    .btn-login {
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      border: none;
      border-radius: 15px;
      padding: 0.875rem 2rem;
      font-size: 1.1rem;
      font-weight: 700;
      color: white;
      width: 100%;
      margin-top: 1rem;
      box-shadow: 0 8px 20px rgba(0, 119, 190, 0.3);
      transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      position: relative;
      overflow: hidden;
    }

    .btn-login::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
      transition: left 0.5s;
    }

    .btn-login:hover {
      transform: translateY(-3px);
      box-shadow: 0 12px 30px rgba(0, 119, 190, 0.4);
    }

    .btn-login:hover::before {
      left: 100%;
    }

    .btn-login:active {
      transform: translateY(-1px);
    }

    /* Alert Styling */
    .alert {
      border-radius: 15px;
      border: none;
      padding: 1rem 1.25rem;
      font-size: 0.95rem;
      animation: shake 0.5s ease;
    }

    .alert-danger {
      background: linear-gradient(135deg, #ff6b6b 0%, #ff8787 100%);
      color: white;
      box-shadow: 0 5px 15px rgba(255, 107, 107, 0.3);
    }

    @keyframes shake {
      0%, 100% { transform: translateX(0); }
      25% { transform: translateX(-10px); }
      75% { transform: translateX(10px); }
    }

    /* Footer Link */
    .login-footer {
      text-align: center;
      margin-top: 1.5rem;
      padding-top: 1.5rem;
      border-top: 2px solid #e0f7fa;
    }

    .login-footer a {
      color: var(--ocean-blue);
      text-decoration: none;
      font-weight: 600;
      transition: all 0.3s ease;
      display: inline-flex;
      align-items: center;
      gap: 0.5rem;
    }

    .login-footer a:hover {
      color: var(--aqua-green);
      transform: translateX(-5px);
    }

    /* Swimming Fish Decoration */
    .fish-decoration {
      position: fixed;
      font-size: 2.5rem;
      pointer-events: none;
      z-index: 5;
      animation: swimAcross 20s linear infinite;
      opacity: 0.3;
      filter: drop-shadow(2px 2px 4px rgba(0, 0, 0, 0.2));
    }

    .fish-decoration:nth-child(2) {
      animation-delay: 7s;
      top: 30%;
      animation-duration: 25s;
    }

    .fish-decoration:nth-child(3) {
      animation-delay: 14s;
      top: 70%;
      animation-duration: 18s;
    }

    @keyframes swimAcross {
      0% {
        left: -100px;
        transform: scaleX(1);
      }
      45% {
        left: 50%;
        transform: scaleX(1);
      }
      50% {
        left: 50%;
        transform: scaleX(-1);
      }
      100% {
        left: 110%;
        transform: scaleX(-1);
      }
    }

    /* Responsive */
    @media (max-width: 576px) {
      .login-card {
        border-radius: 20px;
      }

      .login-header {
        padding: 2rem 1.5rem 1.5rem;
      }

      .login-icon {
        font-size: 3rem;
      }

      .login-header h4 {
        font-size: 1.5rem;
      }

      .login-body {
        padding: 2rem 1.5rem;
      }
    }
  </style>
</head>
<body>

<!-- Bubbles Background -->
<div class="bubbles-container" id="bubblesContainer"></div>

<!-- Swimming Fish Decorations -->
<div class="fish-decoration" style="top: 15%;">🐟</div>
<div class="fish-decoration" style="top: 50%;">🐠</div>
<div class="fish-decoration" style="top: 80%;">🐡</div>

<div class="login-container">
  <div class="login-card">
    <div class="login-header">
      <div class="login-icon">🐠</div>
      <h4>Admin Login</h4>
      <p>Aquarium  Dashboard</p>
    </div>

    <div class="login-body">
      <?php if($this->session->flashdata('err')): ?>
        <div class="alert alert-danger" role="alert">
          <strong>⚠️ Oops!</strong> <?= $this->session->flashdata('err'); ?>
        </div>
      <?php endif; ?>

      <?= form_open('admin/login'); ?>
        <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>

        <div class="mb-3">
          <label class="form-label">Username</label>
          <div class="input-group">
            <span class="input-icon">👤</span>
            <input type="text" 
                   name="username" 
                   value="<?= set_value('username'); ?>" 
                   class="form-control" 
                   placeholder="Masukkan username"
                   required 
                   autocomplete="username">
          </div>
        </div>

        <div class="mb-3">
          <label class="form-label">Password</label>
          <div class="input-group">
            <span class="input-icon">🔒</span>
            <input type="password" 
                   name="password" 
                   class="form-control" 
                   placeholder="Masukkan password"
                   required
                   autocomplete="current-password">
          </div>
        </div>

        <button type="submit" class="btn btn-login">
          Masuk ke Dashboard
        </button>
      <?= form_close(); ?>

      <div class="login-footer">
        <a href="<?= base_url(); ?>">
          ← Kembali ke Beranda
        </a>
      </div>
    </div>
  </div>
</div>

<script>
// Generate bubbles
function createBubbles() {
  const container = document.getElementById('bubblesContainer');
  const bubbleCount = 30;
  
  for (let i = 0; i < bubbleCount; i++) {
    const bubble = document.createElement('div');
    bubble.className = 'bubble';
    
    const size = Math.random() * 60 + 15;
    bubble.style.width = size + 'px';
    bubble.style.height = size + 'px';
    bubble.style.left = Math.random() * 100 + '%';
    
    const duration = (size / 10) + 10 + Math.random() * 8;
    bubble.style.animationDuration = duration + 's';
    bubble.style.animationDelay = Math.random() * 8 + 's';
    
    container.appendChild(bubble);
  }
}

// Initialize bubbles
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', createBubbles);
} else {
  createBubbles();
}

// Add input focus effect
document.querySelectorAll('.form-control').forEach(input => {
  input.addEventListener('focus', function() {
    this.parentElement.style.transform = 'scale(1.02)';
  });
  
  input.addEventListener('blur', function() {
    this.parentElement.style.transform = 'scale(1)';
  });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>