<style>
.hero-section {
  background: linear-gradient(135deg, rgba(13, 110, 139, 0.95), rgba(0, 158, 195, 0.9));
  padding: 80px 0;
  position: relative;
  overflow: hidden;
}

.hero-section::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120"><path d="M0,80 Q300,20 600,80 T1200,80 L1200,120 L0,120 Z" fill="rgba(255,255,255,0.1)"/></svg>') repeat-x;
  opacity: 0.3;
  animation: wave 20s linear infinite;
}

@keyframes wave {
  from { background-position: 0 0; }
  to { background-position: 1200px 0; }
}

.hero-content {
  position: relative;
  z-index: 2;
}

.hero-title {
  color: #ffffff;
  font-size: 3.5rem;
  font-weight: 700;
  text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
  margin-bottom: 1.5rem;
  animation: fadeInUp 1s ease;
}

.hero-subtitle {
  color: rgba(255, 255, 255, 0.95);
  font-size: 1.3rem;
  margin-bottom: 2rem;
  line-height: 1.8;
  animation: fadeInUp 1s ease 0.2s both;
}

.hero-image-container {
  position: relative;
  animation: fadeInRight 1s ease 0.4s both;
}

.hero-image {
  border-radius: 20px;
  box-shadow: 0 20px 60px rgba(0,0,0,0.3);
  border: 5px solid rgba(255, 255, 255, 0.2);
  transition: transform 0.3s ease;
}

.hero-image:hover {
  transform: scale(1.02);
}

@keyframes fadeInUp {
  from {
    opacity: 0;
    transform: translateY(30px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

@keyframes fadeInRight {
  from {
    opacity: 0;
    transform: translateX(30px);
  }
  to {
    opacity: 1;
    transform: translateX(0);
  }
}

.btn-hero {
  background: #ffffff;
  color: #0d6e8b;
  padding: 12px 30px;
  border-radius: 30px;
  font-weight: 600;
  border: none;
  box-shadow: 0 4px 15px rgba(0,0,0,0.2);
  transition: all 0.3s ease;
}

.btn-hero:hover {
  background: #f0f9ff;
  transform: translateY(-2px);
  box-shadow: 0 6px 20px rgba(0,0,0,0.3);
}

.section-title {
  color: #0d6e8b;
  font-size: 2.5rem;
  font-weight: 700;
  text-align: center;
  margin-bottom: 3rem;
  position: relative;
  padding-bottom: 15px;
}

.section-title::after {
  content: '';
  position: absolute;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  width: 100px;
  height: 4px;
  background: linear-gradient(90deg, #0d6e8b, #009ec3);
  border-radius: 2px;
}

.product-card {
  border: none;
  border-radius: 15px;
  overflow: hidden;
  box-shadow: 0 5px 20px rgba(0,0,0,0.1);
  transition: all 0.3s ease;
  background: white;
  height: 100%;
}

.product-card:hover {
  transform: translateY(-10px);
  box-shadow: 0 15px 40px rgba(13, 110, 139, 0.2);
}

.product-card img {
  height: 220px;
  object-fit: cover;
  transition: transform 0.3s ease;
}

.product-card:hover img {
  transform: scale(1.1);
}

.card-img-container {
  overflow: hidden;
  position: relative;
}

.card-img-overlay-badge {
  position: absolute;
  top: 10px;
  right: 10px;
  background: rgba(13, 110, 139, 0.9);
  color: white;
  padding: 5px 15px;
  border-radius: 20px;
  font-size: 0.85rem;
  font-weight: 600;
}

.product-card .card-body {
  padding: 1.5rem;
}

.product-card .card-title {
  color: #0d6e8b;
  font-weight: 700;
  font-size: 1.1rem;
  margin-bottom: 0.8rem;
}

.product-card .card-text {
  color: #666;
  line-height: 1.6;
  margin-bottom: 1rem;
}

.btn-visit {
  background: linear-gradient(135deg, #0d6e8b, #009ec3);
  color: white;
  border: none;
  padding: 8px 25px;
  border-radius: 20px;
  font-weight: 600;
  transition: all 0.3s ease;
}

.btn-visit:hover {
  background: linear-gradient(135deg, #009ec3, #0d6e8b);
  transform: translateX(5px);
  box-shadow: 0 5px 15px rgba(13, 110, 139, 0.3);
}

.decorative-fish {
  position: fixed;
  font-size: 2rem;
  animation: swim 15s linear infinite;
  z-index: 1;
  opacity: 0.3;
}

@keyframes swim {
  from {
    left: -100px;
  }
  to {
    left: calc(100% + 100px);
  }
}

.bubble {
  position: absolute;
  bottom: -50px;
  background: rgba(255, 255, 255, 0.3);
  border-radius: 50%;
  animation: rise 4s infinite ease-in;
}

@keyframes rise {
  to {
    bottom: 110%;
    opacity: 0;
  }
}
</style>

<!-- Hero Section -->
<div class="hero-section">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <div class="hero-content">
          <h1 class="hero-title">🐠 Rifs Aquatics</h1>
          <p class="hero-subtitle">
            Selamat datang di surga akuarium Anda! Temukan berbagai produk berkualitas untuk menciptakan ekosistem akuatik yang sempurna. Dari peralatan canggih hingga dekorasi menawan, kami siap membantu mewujudkan akuarium impian Anda.
          </p>
          <button class="btn btn-hero">Jelajahi Produk</button>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="hero-image-container">
          <img class="img-fluid hero-image" src="<?= base_url('assets/img/ikannya.png'); ?>" alt="Aquarium Paradise">
        </div>
      </div>
    </div>
  </div>
  <!-- Decorative bubbles -->
  <div class="bubble" style="left: 10%; width: 20px; height: 20px; animation-delay: 0s;"></div>
  <div class="bubble" style="left: 30%; width: 15px; height: 15px; animation-delay: 1s;"></div>
  <div class="bubble" style="left: 50%; width: 25px; height: 25px; animation-delay: 2s;"></div>
  <div class="bubble" style="left: 70%; width: 18px; height: 18px; animation-delay: 0.5s;"></div>
  <div class="bubble" style="left: 90%; width: 22px; height: 22px; animation-delay: 1.5s;"></div>
</div>

<!-- Products Section -->
<div class="container my-5 py-5">
  <h3 class="section-title">Koleksi Produk Kami yang paling laris </h3>
  
  <div class="row g-4">
    <?php foreach($items as $index => $it): ?>
      <div class="col-6 col-md-4" style="animation: fadeInUp 0.6s ease <?= $index * 0.1 ?>s both;">
        <div class="card product-card">
          <div class="card-img-container">
            <img class="card-img-top" src="<?= base_url('assets/img/portfolio/'.($it->image ?: 'placeholder.jpg')); ?>" alt="<?= html_escape($it->title); ?>">
            <div class="card-img-overlay-badge">Tersedia</div>
          </div>
          <div class="card-body">
            <h6 class="card-title"><?= html_escape($it->title); ?></h6>
            <p class="card-text small"><?= character_limiter(strip_tags($it->description), 80); ?></p>
            <?php if(!empty($it->url)): ?>
              <a class="btn btn-visit btn-sm" target="_blank" href="<?= $it->url; ?>">
                Kunjungi <i class="fas fa-arrow-right ms-1"></i>
              </a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- Decorative swimming fish -->
<div class="decorative-fish" style="top: 30%; animation-duration: 20s;">🐟</div>
<div class="decorative-fish" style="top: 60%; animation-duration: 25s; animation-delay: 5s;">🐠</div>