
<style>
  /* Enhanced Styling untuk Form Kontak */
  .kontak-container {
    width: 100%;
    padding: 40px 20px;
  }

  .kontak-header {
    text-align: center;
    margin-bottom: 40px;
    animation: slideDown 0.6s ease-out;
  }

  .kontak-header h2 {
    font-size: 2.5rem;
    background: linear-gradient(135deg, #0891b2 0%, #06b6d4 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin: 0;
    font-weight: 700;
  }

  .kontak-header p {
    color: #666;
    font-size: 1rem;
    margin-top: 10px;
  }

  .kontak-form {
    background: linear-gradient(135deg, #ffffff 0%, #f0f9ff 100%);
    border-radius: 15px;
    padding: 50px 60px;
    box-shadow: 0 10px 40px rgba(6, 182, 212, 0.1);
    border: 1px solid rgba(6, 182, 212, 0.1);
    transition: all 0.3s ease;
  }

  .kontak-form:hover {
    box-shadow: 0 20px 50px rgba(6, 182, 212, 0.15);
  }

  .form-group {
    margin-bottom: 25px;
    animation: slideUp 0.6s ease-out;
    animation-fill-mode: both;
  }

  .form-group:nth-child(1) { animation-delay: 0.1s; }
  .form-group:nth-child(2) { animation-delay: 0.2s; }
  .form-group:nth-child(3) { animation-delay: 0.3s; }
  .form-group:nth-child(4) { animation-delay: 0.4s; }

  .form-label {
    display: block;
    font-weight: 600;
    color: #1e3a8a;
    margin-bottom: 10px;
    font-size: 0.95rem;
    letter-spacing: 0.3px;
  }

  .form-control {
    width: 100%;
    padding: 12px 15px;
    border: 2px solid #e0f2fe;
    border-radius: 10px;
    font-size: 1rem;
    font-family: inherit;
    transition: all 0.3s ease;
    background-color: white;
  }

  .form-control:focus {
    outline: none;
    border-color: #0891b2;
    background-color: #f0f9ff;
    box-shadow: 0 0 0 3px rgba(8, 145, 178, 0.1);
    transform: translateY(-2px);
  }

  .form-control::placeholder {
    color: #cbd5e1;
  }

  textarea.form-control {
    resize: vertical;
    min-height: 120px;
  }

  textarea.form-control::-webkit-scrollbar {
    width: 6px;
  }

  textarea.form-control::-webkit-scrollbar-track {
    background: #f0f9ff;
    border-radius: 10px;
  }

  textarea.form-control::-webkit-scrollbar-thumb {
    background: #0891b2;
    border-radius: 10px;
  }

  textarea.form-control::-webkit-scrollbar-thumb:hover {
    background: #0e7490;
  }

  .text-danger {
    color: #dc2626;
    font-size: 0.85rem;
    margin-top: 6px;
    display: block;
    animation: shake 0.3s ease;
  }

  .alert {
    border-radius: 10px;
    border: none;
    margin-bottom: 25px;
    padding: 15px 20px;
    font-weight: 500;
    animation: slideDown 0.4s ease-out;
  }

  .alert-success {
    background-color: #dcfce7;
    color: #166534;
    box-shadow: 0 4px 12px rgba(34, 197, 94, 0.15);
  }

  .alert-danger {
    background-color: #fee2e2;
    color: #991b1b;
    box-shadow: 0 4px 12px rgba(220, 38, 38, 0.15);
  }

  .btn-kirim {
    width: 100%;
    padding: 13px 30px;
    background: linear-gradient(135deg, #0891b2 0%, #06b6d4 100%);
    color: white;
    border: none;
    border-radius: 10px;
    font-size: 1rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    letter-spacing: 0.5px;
    margin-top: 10px;
    animation: slideUp 0.6s ease-out 0.5s both;
    box-shadow: 0 4px 15px rgba(8, 145, 178, 0.3);
  }

  .btn-kirim:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(8, 145, 178, 0.4);
    background: linear-gradient(135deg, #0e7490 0%, #0891b2 100%);
  }

  .btn-kirim:active {
    transform: translateY(-1px);
  }

  .btn-kirim:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
  }

  @keyframes slideDown {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

  @keyframes slideUp {
    from {
      opacity: 0;
      transform: translateY(20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

  @keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
  }

  /* Responsive Design */
  @media (max-width: 768px) {
    .kontak-container {
      padding: 20px 15px;
    }

    .kontak-form {
      padding: 25px;
    }

    .kontak-header h2 {
      font-size: 1.8rem;
    }

    .form-control {
      padding: 11px 13px;
      font-size: 16px; /* Prevents zoom on iOS */
    }
  }
</style>

<div class="kontak-container">
  <div class="kontak-header">
    <h2>Hubungi Kami</h2>
    <p>Silahkan Kirim pesan</p>
  </div>

  <?php if($this->session->flashdata('ok')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('ok'); ?></div>
  <?php elseif($this->session->flashdata('err')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('err'); ?></div>
  <?php endif; ?>

  <?= form_open('pages/kirim_kontak'); ?>
    <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
    
    <div class="kontak-form">
      <div class="form-group">
        <label class="form-label">Nama</label>
        <input type="text" name="nama" value="<?= set_value('nama'); ?>" class="form-control" placeholder="Masukkan nama lengkap Anda">
        <?= form_error('nama','<small class="text-danger">','</small>'); ?>
      </div>

      <div class="form-group">
        <label class="form-label">Email</label>
        <input type="email" name="email" value="<?= set_value('email'); ?>" class="form-control" placeholder="contoh@email.com">
        <?= form_error('email','<small class="text-danger">','</small>'); ?>
      </div>

      <div class="form-group">
        <label class="form-label">Nomor HP</label>
        <input type="tel" name="nomer_hp" value="<?= set_value('nomer_hp'); ?>" class="form-control" placeholder="Contoh: 08123456789">
        <?= form_error('nomer_hp','<small class="text-danger">','</small>'); ?>
      </div>

      <div class="form-group">
        <label class="form-label">Pesan</label>
        <textarea name="pesan" class="form-control" placeholder="Tuliskan pesan atau pertanyaan Anda di sini..."><?= set_value('pesan'); ?></textarea>
        <?= form_error('pesan','<small class="text-danger">','</small>'); ?>
      </div>

      <button type="submit" class="btn-kirim">Kirim Pesan</button>
    </div>
  <?= form_close(); ?>
</div>