<style>
:root {
  --ocean-blue: #0077be;
  --aqua-green: #00bfa5;
  --deep-blue: #004d7a;
  --light-blue: #e0f7fa;
  --coral: #ff6b6b;
}

.products-hero {
  background: linear-gradient(135deg, var(--ocean-blue) 0%, var(--aqua-green) 100%);
  padding: 3rem 0 2rem;
  margin-bottom: 3rem;
  border-radius: 0 0 50% 50% / 0 0 20px 20px;
  box-shadow: 0 10px 30px rgba(0, 119, 190, 0.2);
}

.products-hero h2 {
  color: white;
  font-size: 2.5rem;
  font-weight: 700;
  text-align: center;
  margin: 0;
  text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2);
  letter-spacing: 1px;
}

.products-hero::after {
  content: '🐠';
  display: block;
  text-align: center;
  font-size: 2rem;
  margin-top: 1rem;
  animation: swim 3s ease-in-out infinite;
}

@keyframes swim {
  0%, 100% { transform: translateX(-10px); }
  50% { transform: translateX(10px); }
}

.empty-state {
  text-align: center;
  padding: 4rem 2rem;
  background: linear-gradient(135deg, var(--light-blue) 0%, #ffffff 100%);
  border-radius: 20px;
  border: 2px dashed var(--aqua-green);
  margin: 2rem 0;
}

.empty-state::before {
  content: '🐟';
  display: block;
  font-size: 4rem;
  margin-bottom: 1rem;
  opacity: 0.5;
}

.empty-state p {
  color: var(--deep-blue);
  font-size: 1.1rem;
  margin: 0;
}

.product-card {
  border: none;
  border-radius: 20px;
  overflow: hidden;
  background: white;
  transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
  box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
  position: relative;
}

.product-card::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  height: 4px;
  background: linear-gradient(90deg, var(--ocean-blue), var(--aqua-green));
  transform: scaleX(0);
  transition: transform 0.3s ease;
}

.product-card:hover {
  transform: translateY(-10px);
  box-shadow: 0 15px 40px rgba(0, 119, 190, 0.25);
}

.product-card:hover::before {
  transform: scaleX(1);
}

.product-image-wrapper {
  position: relative;
  overflow: hidden;
  height: 250px;
  background: linear-gradient(135deg, var(--light-blue) 0%, #f0f9ff 100%);
}

.product-card img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  transition: transform 0.5s ease;
}

.product-card:hover img {
  transform: scale(1.1);
}

.product-badge {
  position: absolute;
  top: 15px;
  right: 15px;
  background: rgba(255, 255, 255, 0.95);
  padding: 5px 12px;
  border-radius: 20px;
  font-size: 0.75rem;
  font-weight: 600;
  color: var(--ocean-blue);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
  backdrop-filter: blur(10px);
}

.product-body {
  padding: 1.5rem;
}

.product-name {
  color: var(--deep-blue);
  font-size: 1.25rem;
  font-weight: 700;
  margin-bottom: 0.75rem;
  line-height: 1.3;
}

.product-code {
  display: inline-block;
  background: var(--light-blue);
  color: var(--ocean-blue);
  padding: 4px 10px;
  border-radius: 8px;
  font-size: 0.8rem;
  font-weight: 600;
  margin-bottom: 1rem;
  font-family: 'Courier New', monospace;
}

.product-price {
  font-size: 1.5rem;
  font-weight: 800;
  background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
  margin-bottom: 1rem;
  display: inline-block;
}

.product-note {
  background: #fff8e1;
  border-left: 3px solid #ffc107;
  padding: 0.75rem;
  border-radius: 8px;
  font-size: 0.9rem;
  color: #5d4037;
  margin-bottom: 1rem;
  line-height: 1.5;
}

.product-description {
  color: #546e7a;
  line-height: 1.6;
  font-size: 0.95rem;
}

.wave-divider {
  width: 100%;
  height: 30px;
  background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1200 120'%3E%3Cpath d='M321.39 56.44c58-10.79 114.16-30.13 172-41.86 82.39-16.72 168.19-17.73 250.45-.39C823.78 31 906.67 72 985.66 92.83c70.05 18.48 146.53 26.09 214.34 3V0H0v27.35a600.21 600.21 0 00321.39 29.09z' fill='%2300bfa5' fill-opacity='0.1'/%3E%3C/svg%3E") no-repeat center;
  background-size: cover;
  margin: 2rem 0;
}

.bubbles-container {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  pointer-events: none;
  z-index: 1;
  overflow: hidden;
}

.bubble {
  position: absolute;
  bottom: -100px;
  background: radial-gradient(circle at 30% 30%, rgba(255, 255, 255, 0.8), rgba(0, 191, 165, 0.4));
  border-radius: 50%;
  opacity: 0.6;
  animation: rise linear infinite;
  box-shadow: inset 0 0 10px rgba(255, 255, 255, 0.5),
              0 0 20px rgba(0, 191, 165, 0.3);
}

.bubble::before {
  content: '';
  position: absolute;
  top: 10%;
  left: 15%;
  width: 30%;
  height: 30%;
  background: rgba(255, 255, 255, 0.6);
  border-radius: 50%;
  filter: blur(2px);
}

@keyframes rise {
  0% {
    bottom: -100px;
    transform: translateX(0) scale(1);
    opacity: 0;
  }
  10% {
    opacity: 0.6;
  }
  50% {
    transform: translateX(20px) scale(1.1);
  }
  90% {
    opacity: 0.6;
  }
  100% {
    bottom: 110vh;
    transform: translateX(-20px) scale(0.8);
    opacity: 0;
  }
}

@media (max-width: 768px) {
  .products-hero h2 {
    font-size: 2rem;
  }
  
  .product-image-wrapper {
    height: 200px;
  }
}
</style>

<div class="products-hero">
  <div class="container">
    <h2>Koleksi Produk Akuarium</h2>
  </div>
</div>

<div class="container">
  <?php if (empty($items)): ?>
    <div class="empty-state">
      <p>Belum ada produk tersedia saat ini. Silakan cek kembali nanti!</p>
    </div>
  <?php else: ?>
    <div class="wave-divider"></div>
    
    <div class="row g-4">
      <?php foreach($items as $it): ?>
        <div class="col-lg-4 col-md-6">
          <div class="card product-card h-100">
            <div class="product-image-wrapper">
              <img src="<?= base_url('assets/img/products/'.($it->image ?: 'placeholder.jpg')); ?>"
                   alt="<?= html_escape($it->name); ?>">
              <?php if (!empty($it->kode)): ?>
                <div class="product-badge"><?= html_escape($it->kode); ?></div>
              <?php endif; ?>
            </div>

            <div class="product-body">
              <h5 class="product-name"><?= html_escape($it->name); ?></h5>

              <div class="product-price">
                Rp <?= number_format($it->price, 0, ',', '.'); ?>
              </div>

              <?php if (!empty($it->keterangan)): ?>
                <div class="product-note">
                  <?= nl2br(html_escape($it->keterangan)); ?>
                </div>
              <?php endif; ?>

              <div class="product-description">
                <?= nl2br(html_escape(mb_strimwidth((string)$it->description, 0, 160, '…', 'UTF-8'))); ?>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <div class="wave-divider"></div>
  <?php endif; ?>
</div>